#include "GLOBAL.H"


#define    T0_50MSL         0xB0                 // ( 65536 - 50000 )%256 in 12.0Mhz
#define    T0_50MSH         0x3C                 // ( 65536 - 50000 )/256 in 12.0Mhz
#define    T0_TIMEROUT      60                   // 60*50ms = 3s

BYTE T0Cnt;                                      // Timer0 Count


//----- MCU.C -----//
extern void Reboot_Mcu( BYTE );


void INT_TIMER0(void) interrupt 1 using 1        // Timer0 Interrupt
{ TL0 = T0_50MSL;
  TH0 = T0_50MSH;
  
  T0Cnt++;
  if ( T0Cnt > T0_TIMEROUT )                     // MCU Power on without UART Data in
    Reboot_Mcu( REBOOT_TO_AP );
}


void Initial_TIMER0( void )
{ TMOD |= 0x01;                                  // Set Timer0 in mode 1, 16bit timer/counter Mode
  
  TL0 = T0_50MSL;
  TH0 = T0_50MSH;

  T0Cnt = 0;
}